@extends('layouts.app')

@section('content')
<div class="container py-5">
    
    <!-- Breadcrumb -->
    <nav aria-label="breadcrumb" class="mb-4">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ url('/') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ url('/missing') }}">Missing Persons</a></li>
            <li class="breadcrumb-item active" aria-current="page">Case #12345</li>
        </ol>
    </nav>

    <div class="row g-5">
        <!-- Case Details -->
        <div class="col-lg-7">
            <div class="card shadow-sm border-0 rounded-4 overflow-hidden mb-4">
                <div class="bg-light d-flex align-items-center justify-content-center" style="height: 400px;">
                     <!-- Placeholder for actual image -->
                     <i class="fa-solid fa-user fa-5x text-muted opacity-25"></i>
                </div>
                <div class="card-body p-4">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <div>
                            <h2 class="fw-bold mb-1">Jane Doe</h2>
                            <span class="badge bg-danger rounded-pill px-3">Missing since Jan 15, 2024</span>
                        </div>
                        <div class="text-end">
                            <button class="btn btn-outline-secondary btn-sm"><i class="fa-solid fa-share-nodes me-1"></i> Share</button>
                        </div>
                    </div>

                    <div class="row g-4 mb-4">
                        <div class="col-6 col-md-3">
                            <p class="text-muted small mb-0 uppercase fw-bold">Age</p>
                            <p class="fw-bold fs-5">24 Years</p>
                        </div>
                        <div class="col-6 col-md-3">
                            <p class="text-muted small mb-0 uppercase fw-bold">Gender</p>
                            <p class="fw-bold fs-5">Female</p>
                        </div>
                        <div class="col-6 col-md-3">
                            <p class="text-muted small mb-0 uppercase fw-bold">Height</p>
                            <p class="fw-bold fs-5">5' 6"</p>
                        </div>
                        <div class="col-6 col-md-3">
                            <p class="text-muted small mb-0 uppercase fw-bold">Complexion</p>
                            <p class="fw-bold fs-5">Fair</p>
                        </div>
                    </div>

                    <h5 class="fw-bold text-primary mb-3">Description</h5>
                    <p class="text-muted mb-4">
                        Last seen wearing a blue denim jacket and black jeans. Carrying a red backpack. Has a small scar on the left eyebrow. Speaks English and Hindi.
                    </p>

                    <h5 class="fw-bold text-primary mb-3">Last Seen Location</h5>
                    <p class="text-muted">
                        <i class="fa-solid fa-map-pin text-danger me-2"></i> Near Central Station, Platform 4, New Delhi.
                    </p>
                    
                    <div class="alert alert-info border-0 bg-info bg-opacity-10 mt-4">
                        <i class="fa-solid fa-circle-info me-2"></i>
                        <strong>Official FIR Registered:</strong> Verified by Platform
                    </div>
                </div>
            </div>
        </div>

        <!-- Contact/finder Form -->
        <div class="col-lg-5">
            <div class="card shadow-lg border-0 rounded-4 sticky-top" style="top: 100px;">
                <div class="card-header bg-primary text-white p-4">
                    <h4 class="fw-bold m-0"><i class="fa-solid fa-eye me-2"></i>I Have Information</h4>
                    <p class="small text-white-50 m-0 mt-1">Send a secure message to the reporter.</p>
                </div>
                <div class="card-body p-4">
                    <form action="#" method="POST">
                        @csrf
                        
                        <div class="mb-3">
                            <label class="form-label fw-medium small">Your Message / Sighting Details <span class="text-danger">*</span></label>
                            <textarea class="form-control bg-light border-0" rows="5" required placeholder="I saw someone matching this description at..."></textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-medium small">Your Contact (Optional)</label>
                            <input type="text" class="form-control bg-light border-0" placeholder="Phone or Email if you want them to reply">
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-medium small">Upload Evidence (Optional)</label>
                            <input type="file" class="form-control">
                        </div>

                        <div class="d-grid mt-4">
                            <button type="submit" class="btn btn-primary btn-lg fw-bold">
                                <i class="fa-solid fa-paper-plane me-2"></i> Send Information
                            </button>
                        </div>
                        
                        <div class="text-center mt-3">
                            <small class="text-muted">
                                <i class="fa-solid fa-lock me-1"></i> Your details are kept private.
                            </small>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
