@extends('layouts.app')

@section('content')
<div class="bg-soft min-vh-100 py-5">
    <div class="container">
        <div class="row">
            <!-- Sidebar Filters -->
            <div class="col-lg-3 mb-4">
                <div class="card shadow-sm border-0 sticky-top" style="top: 100px; z-index: 1;">
                    <div class="card-header bg-white py-3">
                        <h5 class="fw-bold m-0"><i class="fa-solid fa-filter me-2 text-primary"></i>Filters</h5>
                    </div>
                    <div class="card-body">
                        <form action="{{ url('/missing') }}" method="GET">
                            <div class="mb-3">
                                <label class="form-label small fw-bold">City / Location</label>
                                <input type="text" class="form-control bg-light border-0" name="city" placeholder="Search City">
                            </div>
                            
                            <div class="mb-3">
                                <label class="form-label small fw-bold">Gender</label>
                                <select class="form-select bg-light border-0" name="gender">
                                    <option value="">All</option>
                                    <option value="Male">Male</option>
                                    <option value="Female">Female</option>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label small fw-bold">Age Range</label>
                                <div class="d-flex gap-2">
                                    <input type="number" class="form-control bg-light border-0" name="min_age" placeholder="Min">
                                    <input type="number" class="form-control bg-light border-0" name="max_age" placeholder="Max">
                                </div>
                            </div>
                            
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">Apply Filters</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Results Grid -->
            <div class="col-lg-9">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4 class="fw-bold m-0">Active Cases</h4>
                    <span class="text-muted small">Showing 12 active cases</span>
                </div>

                <div class="row g-4">
                    <!-- Loop this card -->
                    @for($i = 0; $i < 6; $i++)
                    <div class="col-md-6 col-lg-4">
                        <div class="card h-100 hover-shadow transition-all">
                            <!-- Image Container with Blur Effect -->
                            <div class="position-relative overflow-hidden bg-light" style="height: 220px;">
                                <!-- Placeholder Image -->
                                <div class="w-100 h-100 d-flex align-items-center justify-content-center bg-secondary text-white fw-bold display-4" 
                                     style="filter: blur(8px); transform: scale(1.1); transition: filter 0.3s ease;">
                                    User
                                </div>
                                <div class="position-absolute top-0 end-0 m-2">
                                    <span class="badge bg-danger">Missing</span>
                                </div>
                                <div class="position-absolute bottom-0 start-0 w-100 p-2 bg-gradient-dark text-white text-center small" style="background: rgba(0,0,0,0.5);">
                                    Tap to view details
                                </div>
                            </div>
                            
                            <div class="card-body">
                                <h5 class="card-title fw-bold mb-1">Name Hidden</h5>
                                <div class="d-flex justify-content-between text-muted small mb-2">
                                    <span><i class="fa-solid fa-venus-mars me-1"></i> Female</span>
                                    <span><i class="fa-solid fa-hourglass me-1"></i> 24 Yrs</span>
                                </div>
                                <p class="card-text text-muted small text-truncate">
                                    <i class="fa-solid fa-location-dot text-danger me-1"></i>
                                    Last seen in Andheri, Mumbai...
                                </p>
                            </div>
                            <div class="card-footer bg-white border-top-0 pt-0 pb-3">
                                <a href="{{ url('/missing/1') }}" class="btn btn-outline-primary w-100 btn-sm fw-bold">
                                    <i class="fa-solid fa-eye me-1"></i> I Have Information
                                </a>
                            </div>
                        </div>
                    </div>
                    @endfor
                </div>

                <!-- Pagination -->
                <nav class="mt-5">
                    <ul class="pagination justify-content-center">
                        <li class="page-item disabled"><a class="page-link" href="#">Previous</a></li>
                        <li class="page-item active"><a class="page-link" href="#">1</a></li>
                        <li class="page-item"><a class="page-link" href="#">2</a></li>
                        <li class="page-item"><a class="page-link" href="#">3</a></li>
                        <li class="page-item"><a class="page-link" href="#">Next</a></li>
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</div>
@endsection
