@extends('layouts.app')

@section('content')
<div class="bg-soft py-5">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="d-flex align-items-center mb-4">
                    <a href="{{ url('/') }}" class="text-decoration-none text-muted small me-3"><i class="fa-solid fa-arrow-left"></i> Back</a>
                    <h2 class="fw-bold m-0">Report a Missing Person</h2>
                </div>
                
                <form method="POST" action="{{ route('missing.store') }}" enctype="multipart/form-data">
                    @csrf
                    
                    <!-- Section 1: Reporter Info -->
                    <div class="card shadow-sm border-0 rounded-3 mb-4">
                        <div class="card-header bg-white py-3 border-bottom-0">
                            <h5 class="fw-bold text-primary m-0"><i class="fa-solid fa-user-shield me-2"></i>Reporter Information</h5>
                            <p class="text-muted small m-0">Your details remain private and are only for verification.</p>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Relation with Missing Person <span class="text-danger">*</span></label>
                                    <select class="form-select bg-light border-0" name="relation" required>
                                        <option value="">Select Relation</option>
                                        <option value="Parent">Parent</option>
                                        <option value="Sibling">Sibling</option>
                                        <option value="Spouse">Spouse</option>
                                        <option value="Relative">Other Relative</option>
                                        <option value="Friend">Friend</option>
                                        <option value="Concerned Citizen">Concerned Citizen</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Your Contact Number <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control bg-light border-0" name="reporter_contact" required placeholder="For official verification">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">City <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control bg-light border-0" name="reporter_city" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">State <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control bg-light border-0" name="reporter_state" required>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Section 2: Missing Person Details -->
                    <div class="card shadow-sm border-0 rounded-3 mb-4">
                        <div class="card-header bg-white py-3 border-bottom-0">
                            <h5 class="fw-bold text-primary m-0"><i class="fa-solid fa-user-injured me-2"></i>Missing Person Details</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-12">
                                    <label class="form-label fw-medium small">Full Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control bg-light border-0" name="name" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label fw-medium small">Age <span class="text-danger">*</span></label>
                                    <input type="number" class="form-control bg-light border-0" name="age" required min="1" max="120">
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label fw-medium small">Gender <span class="text-danger">*</span></label>
                                    <select class="form-select bg-light border-0" name="gender" required>
                                        <option value="">Select</option>
                                        <option value="Male">Male</option>
                                        <option value="Female">Female</option>
                                        <option value="Other">Other</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="form-label fw-medium small">Height (Approx)</label>
                                    <input type="text" class="form-control bg-light border-0" name="height" placeholder="e.g. 5ft 6in">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Complexion</label>
                                    <select class="form-select bg-light border-0" name="complexion">
                                        <option value="">Select</option>
                                        <option value="Fair">Fair</option>
                                        <option value="Wheatish">Wheatish</option>
                                        <option value="Dark">Dark</option>
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Language Spoken</label>
                                    <input type="text" class="form-control bg-light border-0" name="language">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Date Missing <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control bg-light border-0" name="date_missing" required>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Last Seen Location <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control bg-light border-0" name="last_seen_location" required placeholder="Area, City">
                                </div>
                                <div class="col-12">
                                    <label class="form-label fw-medium small">Medical Condition (Optional)</label>
                                    <textarea class="form-control bg-light border-0" name="medical_condition" rows="2" placeholder="e.g. Memory loss, Diabetes, etc."></textarea>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Section 3: Identification -->
                    <div class="card shadow-sm border-0 rounded-3 mb-4">
                        <div class="card-header bg-white py-3 border-bottom-0">
                            <h5 class="fw-bold text-primary m-0"><i class="fa-solid fa-id-card me-2"></i>Identification & Documents</h5>
                        </div>
                        <div class="card-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Recent Photograph <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control" name="photo" accept="image/*" required>
                                    <div class="form-text small">Clear face photo prefers. Max 5MB.</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">FIR Copy <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control" name="fir_copy" accept=".pdf,image/*" required>
                                    <div class="form-text small">Official Police Complaint copy. Required for listing approval.</div>
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Birthmark / Scar / Tattoo</label>
                                    <input type="text" class="form-control bg-light border-0" name="identification_marks" placeholder="Any visible marks">
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label fw-medium small">Clothes Worn Last Time</label>
                                    <input type="text" class="form-control bg-light border-0" name="clothes" placeholder="Color, Type of clothes">
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Section 4: Declaration -->
                    <div class="card shadow-sm border-0 rounded-3 mb-4 border-warning border-start border-4">
                        <div class="card-body">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="declaration_check" name="genuine_declaration" required>
                                <label class="form-check-label" for="declaration_check">
                                    <strong>I hereby declare that the information provided is true and the FIR is genuine.</strong><br>
                                    <span class="text-muted small">Submitting false reports regarding missing persons is a punishable offense.</span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <button type="button" class="btn btn-light me-md-2" onclick="window.history.back()">Cancel</button>
                        <button type="submit" class="btn btn-primary px-5 py-2 fw-bold">Submit Report</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</div>
@endsection
