@extends('layouts.app')

@section('content')
<!-- Hero Section -->
<section class="d-flex align-items-center position-relative overflow-hidden" style="background: linear-gradient(135deg, #FDFBFB 0%, #EBEDEE 100%); min-height: 80vh; padding: 4rem 0;">
    <div class="container position-relative z-index-2">
        <div class="row align-items-center">
            <div class="col-lg-6 mb-5 mb-lg-0">
                <span class="badge bg-primary bg-opacity-10 text-primary mb-3 px-3 py-2 rounded-pill fw-medium">Community Initiative</span>
                <h1 class="display-3 fw-bold mb-4" style="letter-spacing: -1px; color: #1a1a1a;">
                    Help Reunite <br>
                    <span class="text-primary">Missing People</span> <br>
                    With Families
                </h1>
                <p class="lead text-muted mb-5" style="max-width: 500px;">
                    A secure platform to report missing persons and share information safely. Your help can bring a loved one home.
                </p>
                <div class="d-flex flex-wrap gap-3">
                    <a href="{{ url('/missing/create') }}" class="btn btn-primary btn-lg px-5 py-3 shadow-sm rounded-3">
                        <i class="fa-solid fa-bullhorn me-2"></i> Report Missing
                    </a>
                    <a href="{{ url('/missing') }}" class="btn btn-white btn-lg px-5 py-3 shadow-sm rounded-3 border text-primary bg-white">
                        <i class="fa-solid fa-search me-2"></i> I Found Someone
                    </a>
                </div>
            </div>
            <div class="col-lg-6 position-relative text-center">
                <!-- Abstract Illustration created with CSS shapes or FontAwesome for calm look -->
                <div class="position-relative d-inline-block">
                    <div class="p-5 bg-white rounded-circle shadow-lg" style="width: 300px; height: 300px; display: flex; align-items: center; justify-content: center; z-index: 2; position: relative;">
                         <i class="fa-solid fa-hand-holding-heart text-primary" style="font-size: 8rem; opacity: 0.8;"></i>
                    </div>
                    <!-- Decorative circles -->
                    <div class="position-absolute top-0 start-0 translate-middle bg-info opacity-10 rounded-circle" style="width: 200px; height: 200px; z-index: 1;"></div>
                    <div class="position-absolute bottom-0 end-0 translate-middle bg-warning opacity-10 rounded-circle" style="width: 150px; height: 150px; z-index: 1;"></div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- How It Works -->
<section id="how-it-works" class="section-padding bg-white">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold display-6">How It Works</h2>
            <p class="text-muted">Simple steps to help the community</p>
        </div>
        
        <div class="row g-4 text-center">
            <!-- Step 1 -->
            <div class="col-md-4">
                <div class="p-4 h-100">
                    <div class="mb-4 d-inline-flex align-items-center justify-content-center bg-primary bg-opacity-10 text-primary rounded-circle" style="width: 80px; height: 80px;">
                        <i class="fa-solid fa-file-pen fa-2x"></i>
                    </div>
                    <h4 class="fw-bold mb-3">1. Report Details</h4>
                    <p class="text-muted">Submit verified details of the missing person, including photos and FIR copy for validation.</p>
                </div>
            </div>
            
            <!-- Step 2 -->
            <div class="col-md-4">
                <div class="p-4 h-100">
                    <div class="mb-4 d-inline-flex align-items-center justify-content-center bg-danger bg-opacity-10 text-danger rounded-circle" style="width: 80px; height: 80px;">
                         <i class="fa-solid fa-earth-americas fa-2x"></i>
                    </div>
                    <h4 class="fw-bold mb-3">2. Community Alert</h4>
                    <p class="text-muted">The profile is listed publicly (with sensitive data hidden) for the community to recognize.</p>
                </div>
            </div>
            
            <!-- Step 3 -->
            <div class="col-md-4">
                <div class="p-4 h-100">
                    <div class="mb-4 d-inline-flex align-items-center justify-content-center bg-success bg-opacity-10 text-success rounded-circle" style="width: 80px; height: 80px;">
                        <i class="fa-solid fa-handshake-simple fa-2x"></i>
                    </div>
                    <h4 class="fw-bold mb-3">3. Safe Reunification</h4>
                    <p class="text-muted">If found, people can contact the reporter securely through our platform without exposing numbers.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Active Cases Preview -->
<section class="section-padding bg-soft">
    <div class="container">
        <div class="d-flex justify-content-between align-items-end mb-5">
            <div>
                <h2 class="fw-bold display-6">Recent Active Cases</h2>
                <p class="text-muted mb-0">Help us find these people</p>
            </div>
            <a href="{{ url('/missing') }}" class="btn btn-outline-primary">View All Cases</a>
        </div>
        
        <div class="row g-4">
            <!-- Mock Card 1 -->
            <div class="col-md-6 col-lg-3">
                <div class="card h-100">
                    <div class="bg-light d-flex align-items-center justify-content-center text-muted" style="height: 200px;">
                        <i class="fa-solid fa-image fa-2x opacity-25"></i>
                    </div>
                    <div class="card-body">
                        <span class="badge bg-warning text-dark mb-2">Missing</span>
                        <h5 class="card-title fw-bold">Rahul Kumar</h5>
                        <p class="card-text text-muted small mb-1">Age: 12 • Male</p>
                        <p class="card-text text-muted small"><i class="fa-solid fa-location-dot text-danger me-1"></i> New Delhi</p>
                        <a href="#" class="btn btn-sm btn-light w-100 mt-2 text-primary fw-medium stretched-link">View Details</a>
                    </div>
                </div>
            </div>
             <!-- Mock Card 2 -->
             <div class="col-md-6 col-lg-3">
                <div class="card h-100">
                     <div class="bg-light d-flex align-items-center justify-content-center text-muted" style="height: 200px;">
                        <i class="fa-solid fa-image fa-2x opacity-25"></i>
                    </div>
                    <div class="card-body">
                        <span class="badge bg-warning text-dark mb-2">Missing</span>
                        <h5 class="card-title fw-bold">Priya Sharma</h5>
                        <p class="card-text text-muted small mb-1">Age: 24 • Female</p>
                        <p class="card-text text-muted small"><i class="fa-solid fa-location-dot text-danger me-1"></i> Mumbai</p>
                        <a href="#" class="btn btn-sm btn-light w-100 mt-2 text-primary fw-medium stretched-link">View Details</a>
                    </div>
                </div>
            </div>
            <!-- Mock Card 3 -->
            <div class="col-md-6 col-lg-3">
                <div class="card h-100">
                     <div class="bg-light d-flex align-items-center justify-content-center text-muted" style="height: 200px;">
                        <i class="fa-solid fa-image fa-2x opacity-25"></i>
                    </div>
                    <div class="card-body">
                        <span class="badge bg-warning text-dark mb-2">Missing</span>
                        <h5 class="card-title fw-bold">Amit Singh</h5>
                        <p class="card-text text-muted small mb-1">Age: 35 • Male</p>
                        <p class="card-text text-muted small"><i class="fa-solid fa-location-dot text-danger me-1"></i> Bangalore</p>
                        <a href="#" class="btn btn-sm btn-light w-100 mt-2 text-primary fw-medium stretched-link">View Details</a>
                    </div>
                </div>
            </div>
             <!-- Mock Card 4 -->
             <div class="col-md-6 col-lg-3">
                <div class="card h-100">
                     <div class="bg-light d-flex align-items-center justify-content-center text-muted" style="height: 200px;">
                        <i class="fa-solid fa-image fa-2x opacity-25"></i>
                    </div>
                    <div class="card-body">
                        <span class="badge bg-success text-white mb-2">Found</span>
                        <h5 class="card-title fw-bold">Sneha Gupta</h5>
                        <p class="card-text text-muted small mb-1">Age: 8 • Female</p>
                        <p class="card-text text-muted small"><i class="fa-solid fa-location-dot text-secondary me-1"></i> Pune</p>
                        <button class="btn btn-sm btn-light w-100 mt-2 text-muted fw-medium disabled">Case Closed</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Privacy & Safety -->
<section class="section-padding bg-dark text-white">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <h3 class="fw-bold mb-3"><i class="fa-solid fa-shield-halved text-success me-2"></i> Your Privacy & Safety is Priority</h3>
                <p class="text-white-50 mb-0">
                    We ensure that reporter contact details are never made public. People who find a match can send messages through our secure system. Your data is protected and only used for the purpose of reunification.
                </p>
            </div>
            <div class="col-lg-4 text-lg-end mt-4 mt-lg-0">
                <a href="#" class="btn btn-outline-light px-4">Read Privacy Policy</a>
            </div>
        </div>
    </div>
</section>
@endsection
