

<?php $__env->startSection('admin_content'); ?>

<!-- Stats Grid -->
<div class="row g-4 mb-5">
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon bg-primary-soft">
                <i class="fa-solid fa-users"></i>
            </div>
            <h6 class="text-muted small fw-700 text-uppercase mb-2">Total Users</h6>
            <h2 class="fw-800 mb-0"><?php echo e($totalUsers); ?></h2>
            <div class="mt-2 small text-primary fw-600">
                <i class="fa-solid fa-user-plus me-1"></i> Registered
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon bg-warning-soft">
                <i class="fa-solid fa-file-shield"></i>
            </div>
            <h6 class="text-muted small fw-700 text-uppercase mb-2">Pending FIR</h6>
            <h2 class="fw-800 mb-0"><?php echo e($pendingVerifications); ?></h2>
            <div class="mt-2 small text-warning fw-600">
                <i class="fa-solid fa-triangle-exclamation me-1"></i> Wait Review
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon bg-success-soft">
                <i class="fa-solid fa-person-running"></i>
            </div>
            <h6 class="text-muted small fw-700 text-uppercase mb-2">Active Cases</h6>
            <h2 class="fw-800 mb-0"><?php echo e($activeCases); ?></h2>
            <div class="mt-2 small text-success fw-600">
                <i class="fa-solid fa-check-circle me-1"></i> Publicly Listing
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="stat-card">
            <div class="stat-icon bg-danger-soft">
                <i class="fa-solid fa-heart"></i>
            </div>
            <h6 class="text-muted small fw-700 text-uppercase mb-2">Resolved</h6>
            <h2 class="fw-800 mb-0"><?php echo e($resolvedCases); ?></h2>
            <div class="mt-2 small text-danger fw-600">
                <i class="fa-solid fa-handshake-angle me-1"></i> Reunited
            </div>
        </div>
    </div>
</div>

<div class="row g-4">
    <!-- Recent Reports -->
    <div class="col-xl-8">
        <div class="table-card">
            <div class="card-header bg-white border-0 py-4 px-4 d-flex justify-content-between align-items-center">
                <h5 class="fw-800 mb-0">Recent Submissions</h5>
                <a href="<?php echo e(route('admin.reports.index')); ?>" class="btn btn-light btn-sm rounded-pill px-3 border-0">View All</a>
            </div>
            <div class="table-responsive">
                <table class="table mb-0">
                    <thead>
                        <tr>
                            <th class="ps-4">Missing Person</th>
                            <th>Reporter</th>
                            <th>FIR Status</th>
                            <th class="text-end pe-4">Manage</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $allCases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td class="ps-4">
                                <div class="d-flex align-items-center">
                                    <img src="<?php echo e(asset('storage/' . $case->photo)); ?>" class="rounded-4 shadow-sm me-3" style="width: 45px; height: 45px; object-fit: cover;">
                                    <div>
                                        <div class="fw-700 text-dark small"><?php echo e($case->name); ?></div>
                                        <div class="text-muted extra-small"><?php echo e($case->last_seen_location); ?></div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="fw-600 text-dark small"><?php echo e($case->user->name); ?></div>
                                <div class="text-muted extra-small"><?php echo e($case->reporter_contact); ?></div>
                            </td>
                            <td>
                                <?php if($case->fir_status == 'Verified'): ?>
                                    <span class="badge-verified">Verified</span>
                                <?php elseif($case->fir_status == 'Rejected'): ?>
                                    <span class="badge bg-danger bg-opacity-10 text-danger px-2 py-1 rounded small">Rejected</span>
                                <?php else: ?>
                                    <span class="badge-pending">Pending</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-end pe-4">
                                <a href="<?php echo e(route('admin.reports.show', $case->id)); ?>" class="btn btn-light btn-sm rounded-pill p-2" style="width: 32px; height: 32px;">
                                    <i class="fa-solid fa-arrow-right text-primary"></i>
                                </a>
                            </td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="4" class="text-center py-5 text-muted small">No recent reports.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Recent Tips -->
    <div class="col-xl-4">
        <div class="card border-0 shadow-sm rounded-4 h-100 bg-white">
            <div class="card-header bg-white border-0 py-4 px-4">
                <h6 class="fw-800 mb-0">Latest Tips / Leads</h6>
            </div>
            <div class="card-body p-4 pt-0">
                <?php $__empty_1 = true; $__currentLoopData = $recentTips; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tip): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="d-flex gap-3 mb-4 last-child-mb-0">
                    <div class="flex-shrink-0">
                        <div class="rounded-circle bg-light p-2 text-center" style="width: 40px; height: 40px;">
                            <i class="fa-solid fa-comment-dots text-primary small"></i>
                        </div>
                    </div>
                    <div>
                        <div class="small fw-700 text-dark">Tip on <?php echo e($tip->missingPerson->name); ?></div>
                        <p class="text-muted extra-small mb-1 text-truncate-2"><?php echo e($tip->message); ?></p>
                        <div class="d-flex align-items-center gap-2">
                             <span class="extra-small text-muted"><?php echo e($tip->created_at->diffForHumans()); ?></span>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-center py-5">
                    <i class="fa-solid fa-message-slash text-light fa-3x mb-3"></i>
                    <p class="text-muted small">No new tips reported yet.</p>
                </div>
                <?php endif; ?>
                
                <?php if(count($recentTips) > 0): ?>
                <a href="<?php echo e(route('admin.messages.index')); ?>" class="btn btn-primary w-100 btn-sm rounded-pill mt-3 py-2 fw-bold shadow-sm">
                    Monitor All Messages
                </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<style>
    .extra-small { font-size: 0.7rem; }
    .text-truncate-2 {
        display: -webkit-box;
        -webkit-line-clamp: 2;
        -webkit-box-orient: vertical;
        overflow: hidden;
    }
    .last-child-mb-0:last-child { margin-bottom: 0 !important; }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\find\app\resources\views/admin/dashboard.blade.php ENDPATH**/ ?>