

<?php $__env->startSection('admin_content'); ?>
<div class="row mb-4">
    <div class="col-8">
        <h4 class="fw-800 mb-0">User Management</h4>
        <p class="text-muted small">Manage platform users and their access.</p>
    </div>
</div>

<div class="table-card">
    <div class="table-responsive">
        <table class="table mb-0 align-middle">
            <thead>
                <tr>
                    <th class="ps-4">User Details</th>
                    <th>Email / Mobile</th>
                    <th>Role</th>
                    <th>Status</th>
                    <th>Joined</th>
                    <th class="text-end pe-4">Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="ps-4">
                        <div class="d-flex align-items-center">
                            <div class="rounded-circle bg-light d-flex align-items-center justify-content-center me-3" style="width: 40px; height: 40px;">
                                <i class="fa-solid fa-user text-muted small"></i>
                            </div>
                            <div>
                                <div class="fw-700 text-dark small"><?php echo e($user->name); ?></div>
                                <div class="extra-small text-muted">ID: #USR<?php echo e(str_pad($user->id, 4, '0', STR_PAD_LEFT)); ?></div>
                            </div>
                        </div>
                    </td>
                    <td>
                        <div class="small fw-600 text-dark mb-0 line-height-1"><?php echo e($user->email); ?></div>
                        <div class="extra-small text-muted"><?php echo e($user->mobile ?? 'No Mobile'); ?></div>
                    </td>
                    <td>
                        <span class="badge <?php echo e($user->is_admin ? 'bg-primary' : 'bg-light text-dark'); ?> px-3 py-2 rounded-pill extra-small">
                            <?php echo e($user->role ?? ($user->is_admin ? 'Admin' : 'User')); ?>

                        </span>
                    </td>
                    <td>
                        <?php if($user->is_blocked): ?>
                            <span class="badge bg-danger bg-opacity-10 text-danger px-3 py-2 rounded-pill extra-small">Blocked</span>
                        <?php else: ?>
                            <span class="badge bg-success bg-opacity-10 text-success px-3 py-2 rounded-pill extra-small">Active</span>
                        <?php endif; ?>
                    </td>
                    <td>
                        <div class="extra-small text-muted"><?php echo e($user->created_at->format('M d, Y')); ?></div>
                    </td>
                    <td class="text-end pe-4">
                        <div class="btn-group shadow-sm rounded-pill overflow-hidden border">
                            <a href="<?php echo e(route('admin.users.show', $user->id)); ?>" class="btn btn-white btn-sm border-0 px-3" title="View Profile">
                                <i class="fa-solid fa-eye text-primary"></i>
                            </a>
                            <form action="<?php echo e(route('admin.users.toggleBlock', $user->id)); ?>" method="POST" class="d-inline">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-white btn-sm border-0 px-3" title="<?php echo e($user->is_blocked ? 'Unblock' : 'Block'); ?>">
                                    <?php if($user->is_blocked): ?>
                                        <i class="fa-solid fa-unlock text-success"></i>
                                    <?php else: ?>
                                        <i class="fa-solid fa-user-slash text-danger"></i>
                                    <?php endif; ?>
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    </div>
    <div class="card-footer bg-white py-3">
        <?php echo e($users->links()); ?>

    </div>
</div>

<style>
    .line-height-1 { line-height: 1.2; }
    .extra-small { font-size: 0.7rem; }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\find\app\resources\views/admin/users/index.blade.php ENDPATH**/ ?>