@extends('layouts.app')

@section('content')
<div class="bg-soft py-5 min-vh-100">
    <div class="container pt-4 animate__animated animate__fadeIn">
        
        <!-- Breadcrumb & Control Bar -->
        <div class="d-flex flex-column flex-md-row justify-content-between align-items-center mb-5 gap-4">
            <nav aria-label="breadcrumb">
                <ol class="breadcrumb mb-0">
                    <li class="breadcrumb-item"><a href="{{ url('/') }}" class="text-primary text-decoration-none small fw-bold text-uppercase">NETWORK</a></li>
                    <li class="breadcrumb-item"><a href="{{ url('/missing') }}" class="text-primary text-decoration-none small fw-bold text-uppercase">REGISTRY</a></li>
                    <li class="breadcrumb-item active small fw-bold text-muted text-uppercase" aria-current="page">CASE DATA #{{ $missingPerson->id }}</li>
                </ol>
            </nav>
            <div class="d-flex gap-3">
                <button class="btn btn-white shadow-sm rounded-pill px-4 py-2 border small fw-bold text-secondary">
                    <i class="fa-solid fa-share-nodes me-2"></i> BROADCAST CASE
                </button>
                <div class="bg-accent bg-opacity-10 text-accent px-4 py-2 rounded-pill small fw-800 border border-accent border-opacity-20 animate-pulse">
                    <i class="fa-solid fa-circle-exclamation me-2"></i> ACTIVE SEARCH
                </div>
            </div>
        </div>

        <div class="row g-5">
            <!-- Major Intelligence Area -->
            <div class="col-lg-8 animate__animated animate__fadeInUp">
                <!-- Profile Identity Card -->
                <div class="glass-card overflow-hidden border-0 mb-5 bg-white shadow-sm">
                    <div class="row g-0">
                        <div class="col-md-5">
                            <div class="position-relative h-100 min-height-400">
                                @if($missingPerson->photo)
                                    <img src="{{ asset('storage/' . $missingPerson->photo) }}" class="w-100 h-100 object-fit-cover shadow-lg" alt="{{ $missingPerson->name }}" style="border-radius: 0 0 40px 0;">
                                @else
                                    <div class="w-100 h-100 bg-light d-flex align-items-center justify-content-center">
                                        <i class="fa-solid fa-user-tie fa-5x text-muted opacity-10"></i>
                                    </div>
                                @endif
                                <div class="position-absolute bottom-0 start-0 m-3 px-3 py-2 bg-white rounded-pill shadow-sm small fw-800">
                                    <i class="fa-solid fa-calendar-check text-primary me-2"></i>MISSING SINCE {{ $missingPerson->date_missing->format('M d, Y') }}
                                </div>
                            </div>
                        </div>
                        <div class="col-md-7 p-5">
                            <div class="badge bg-primary bg-opacity-10 text-primary px-3 py-2 rounded-4 mb-3 border border-primary border-opacity-10 fw-800 letter-spacing-1 small">CASE IDENTIFIED</div>
                            <h1 class="display-5 fw-800 text-dark mb-4">{{ $missingPerson->name }}</h1>
                            
                            <div class="row g-4 mb-5">
                                <div class="col-6 col-md-4">
                                    <div class="small text-muted fw-800 text-uppercase letter-spacing-1 mb-1">CURRENT AGE</div>
                                    <div class="h4 fw-800 text-primary mb-0">{{ $missingPerson->age }} Years</div>
                                </div>
                                <div class="col-6 col-md-4">
                                    <div class="small text-muted fw-800 text-uppercase letter-spacing-1 mb-1">GENDER</div>
                                    <div class="h4 fw-800 text-primary mb-0">{{ $missingPerson->gender }}</div>
                                </div>
                                <div class="col-6 col-md-4">
                                    <div class="small text-muted fw-800 text-uppercase letter-spacing-1 mb-1">COMPLEXION</div>
                                    <div class="h4 fw-800 text-primary mb-0">{{ $missingPerson->complexion ?? 'NOT SPECIFIED' }}</div>
                                </div>
                            </div>

                            <div class="p-4 bg-light rounded-4 border border-light d-flex align-items-center">
                                <i class="fa-solid fa-map-pin text-accent me-4 fs-3"></i>
                                <div>
                                    <div class="small text-muted fw-800 text-uppercase letter-spacing-1 mb-1">LAST DETECTED LOCATION</div>
                                    <div class="fw-800 text-dark h5 mb-0">{{ $missingPerson->last_seen_location }}</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Secondary Intelligence Modules -->
                <div class="row g-4 mb-5">
                    <div class="col-md-6">
                        <div class="glass-card p-4 h-100 bg-white border-0 shadow-sm border-start border-4 border-primary">
                            <h5 class="fw-800 mb-4 d-flex align-items-center">
                                <i class="fa-solid fa-id-card-clip text-primary me-3"></i>Physical Profile
                            </h5>
                            <ul class="list-unstyled mb-0">
                                <li class="mb-3 d-flex justify-content-between border-bottom border-light pb-2">
                                    <span class="text-secondary small fw-bold">HEIGHT ESTIMATE</span>
                                    <span class="text-dark fw-800">{{ $missingPerson->height ?? 'N/A' }}</span>
                                </li>
                                <li class="mb-3 d-flex justify-content-between border-bottom border-light pb-2">
                                    <span class="text-secondary small fw-bold">LANGUAGE PROFICIENCY</span>
                                    <span class="text-dark fw-800 text-uppercase">{{ $missingPerson->language ?? 'N/A' }}</span>
                                </li>
                                <li class="d-flex justify-content-between">
                                    <span class="text-secondary small fw-bold">IDENTIFICATION MARKS</span>
                                    <span class="text-dark fw-800 text-end">{{ $missingPerson->identification_marks ?? 'NONE REPORTED' }}</span>
                                </li>
                            </ul>
                        </div>
                    </div>
                    
                    <div class="col-md-6">
                        <div class="glass-card p-4 h-100 bg-white border-0 shadow-sm border-start border-4 border-accent">
                            <h5 class="fw-800 mb-4 d-flex align-items-center">
                                <i class="fa-solid fa-shirt text-accent me-3"></i>Last Reported Attire
                            </h5>
                            <div class="p-3 bg-light rounded-4 min-height-100">
                                <p class="text-dark fw-600 mb-0 opacity-75">{{ $missingPerson->clothes ?? 'The reporting officer did not specify the attire worn during the last detection.' }}</p>
                            </div>
                        </div>
                    </div>

                    @if($missingPerson->medical_condition)
                    <div class="col-12">
                        <div class="glass-card p-4 bg-warning bg-opacity-10 border border-warning border-opacity-20 shadow-none">
                            <div class="d-flex align-items-center gap-3 mb-3">
                                <i class="fa-solid fa-hand-holding-medical text-warning fs-3"></i>
                                <h5 class="fw-800 text-dark mb-0 text-uppercase letter-spacing-1">Critical Medical Alert</h5>
                            </div>
                            <p class="text-dark opacity-75 fw-600 mb-0">{{ $missingPerson->medical_condition }}</p>
                        </div>
                    </div>
                    @endif
                </div>

                <!-- Authority Verification Card -->
                <div class="glass-card p-4 bg-dark text-white border-0 shadow-sm">
                    <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-4">
                        <div class="d-flex align-items-center gap-4">
                             <div class="rounded-circle bg-success bg-opacity-20 d-flex align-items-center justify-content-center shadow-lg" style="width: 70px; height: 70px;">
                                 <i class="fa-solid fa-stamp text-success fs-3"></i>
                             </div>
                             <div>
                                 <h5 class="fw-800 mb-1">Official Verification Protocol</h5>
                                 <p class="small mb-0" style="color: rgba(255,255,255,0.7);">This case has matched validated FIR records and is verified by FindMissing Compliance.</p>
                             </div>
                        </div>
                        <div class="px-4 py-2 border border-success border-opacity-50 rounded-pill text-success small fw-800" style="background: rgba(25, 135, 84, 0.1);">
                            LEGAL VALIDITY: SECURE
                        </div>
                    </div>
                </div>
            </div>

            <!-- Side Interaction Panel -->
            <div class="col-lg-4">
                <div class="sticky-top" style="top: 100px;">
                    <!-- Message Submission Box -->
                    <div class="glass-card border-0 bg-white shadow-lg overflow-hidden animate__animated animate__fadeInRight">
                        <div class="bg-primary p-4 text-white">
                            <h4 class="fw-800 mb-1 d-flex align-items-center">
                                <i class="fa-solid fa-satellite-dish me-3"></i>Send Lead
                            </h4>
                            <p class="small text-white text-opacity-75 mb-0">Securely transmit sighting data to the reporter.</p>
                        </div>
                        
                        <div class="card-body p-4">
                            @if(session('success'))
                                <div class="alert alert-success border-0 shadow-sm rounded-4 mb-4 animate__animated animate__bounceIn">
                                    <i class="fa-solid fa-circle-check me-2"></i> {{ session('success') }}
                                </div>
                            @endif

                            <form action="{{ route('tips.store', $missingPerson->id) }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                
                                <div class="mb-4">
                                    <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">INTELLIGENCE DATA <span class="text-accent">*</span></label>
                                    <textarea class="form-control bg-light border-0 py-3 px-4 fw-500" name="message" rows="5" required placeholder="Describe location, time, attire, and state of individual..."></textarea>
                                </div>

                                <div class="mb-4">
                                    <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">SOURCE CONTACT (OPTIONAL)</label>
                                    <div class="position-relative">
                                        <i class="fa-solid fa-phone position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                        <input type="text" name="contact_info" class="form-control bg-light border-0 ps-5 py-2 fw-500" placeholder="Messenger / Phone / Email">
                                    </div>
                                    <div class="form-text extra-small opacity-50 mt-2">Only the case reporter will have access to see this data.</div>
                                </div>
                                
                                <div class="mb-4">
                                    <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">ATTACH EVIDENCE</label>
                                    <div class="p-3 bg-light rounded-4 border-dashed text-center">
                                        <input type="file" name="evidence" class="form-control border-0 bg-transparent shadow-none" accept="image/*,video/*">
                                        <div class="small opacity-50 mt-1">Photos / Video of sightings</div>
                                    </div>
                                </div>

                                <div class="d-grid pt-2">
                                    <button type="submit" class="btn btn-premium py-3 d-flex align-items-center justify-content-center">
                                        TRANSMIT INTELLIGENCE <i class="fa-solid fa-paper-plane ms-2"></i>
                                    </button>
                                </div>
                                
                                <div class="text-center mt-4 pt-3 border-top border-light">
                                    <div class="d-inline-flex align-items-center gap-2 text-muted fw-800 extra-small text-uppercase letter-spacing-1">
                                        <i class="fa-solid fa-lock text-success"></i> END-TO-END ENCRYPTED
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>

                    <!-- Community Impact Side Note -->
                    <div class="mt-4 glass-card p-4 border-0 bg-dark shadow-lg animate__animated animate__fadeInUp animate__delay-1s">
                        <div class="h6 fw-800 mb-3 text-white">Community Protocol</div>
                        <ul class="list-unstyled small fw-600 mb-0">
                            <li class="mb-2 d-flex gap-3 align-items-start">
                                <i class="fa-solid fa-check-double text-success mt-1"></i>
                                <span style="color: rgba(255,255,255,0.7);">Do not confront the individual directly if they appear unstable.</span>
                            </li>
                            <li class="mb-0 d-flex gap-3 align-items-start">
                                <i class="fa-solid fa-check-double text-success mt-1"></i>
                                <span style="color: rgba(255,255,255,0.7);">Note down GPS coordinates or building numbers immediately.</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .letter-spacing-1 { letter-spacing: 1px; }
    .min-height-400 { min-height: 480px; }
    .line-height-1 { line-height: 1; }
    .extra-small { font-size: 0.65rem; }
    .border-dashed { border: 2px dashed #cbd5e1; }
    .animate-pulse {
        animation: pulse 2s infinite;
    }
    @keyframes pulse {
        0% { transform: scale(1); opacity: 1; }
        50% { transform: scale(1.05); opacity: 0.8; }
        100% { transform: scale(1); opacity: 1; }
    }
    
    @media (max-width: 991px) {
        .min-height-400 { min-height: 300px; }
    }
</style>
@endsection
