@extends('layouts.app')

@section('content')
<div class="bg-soft py-5 min-vh-100">
    <div class="container pt-4 animate__animated animate__fadeIn">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                
                <!-- Form Header -->
                <div class="text-center mb-5 animate__animated animate__fadeInDown">
                    <span class="badge bg-primary bg-opacity-10 text-primary px-4 py-2 rounded-pill fw-800 text-uppercase letter-spacing-1 border border-primary border-opacity-20 small mb-3">Compliance protocol phase 1</span>
                    <h1 class="display-4 fw-800 mb-0">File Case <span class="text-primary">Intelligence.</span></h1>
                    <p class="text-secondary fs-5 opacity-75">Submit precise data to activate the community search engine.</p>
                </div>
                
                <form method="POST" action="{{ route('missing.store') }}" enctype="multipart/form-data">
                    @csrf
                    
                    @if ($errors->any())
                        <div class="glass-card p-4 bg-danger bg-opacity-5 border-danger border-opacity-20 mb-5 animate__animated animate__shakeX">
                            <div class="d-flex align-items-center gap-3 text-danger mb-3">
                                <i class="fa-solid fa-triangle-exclamation fs-4"></i>
                                <h5 class="fw-800 mb-0">Data Verification Error</h5>
                            </div>
                            <ul class="mb-0 fw-600 small opacity-75">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                    <div class="row g-5">
                        <!-- Left Pillar: Identity -->
                        <div class="col-lg-6">
                            <!-- Section: Reporter -->
                            <div class="glass-card p-5 border-0 bg-white shadow-sm mb-5 animate__animated animate__fadeInLeft">
                                <div class="d-flex align-items-center gap-4 mb-5">
                                    <div class="bg-primary bg-opacity-10 text-primary rounded-4 d-flex align-items-center justify-content-center shadow-sm" style="width: 50px; height: 50px;">
                                        <i class="fa-solid fa-user-shield fs-4"></i>
                                    </div>
                                    <h4 class="fw-800 mb-0">Protocol Officer</h4>
                                </div>

                                <div class="row g-4">
                                    <div class="col-12">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">RELATIONSHIP WITH INDIVIDUAL <span class="text-accent">*</span></label>
                                        <select class="form-select bg-light border-0 py-3 px-4 fw-600 rounded-4" name="relation" required>
                                            <option value="">Select Protocol Role</option>
                                            <option value="Parent">Parent</option>
                                            <option value="Sibling">Sibling</option>
                                            <option value="Spouse">Spouse</option>
                                            <option value="Relative">Family Relative</option>
                                            <option value="Friend">Trusted Friend</option>
                                            <option value="Concerned Citizen">Community Sighter</option>
                                        </select>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">OFFICIAL CONTACT <span class="text-accent">*</span></label>
                                        <div class="position-relative">
                                            <i class="fa-solid fa-phone-volume position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                            <input type="tel" class="form-control bg-light border-0 ps-5 py-3 fw-600 rounded-4" name="reporter_contact" required placeholder="Verification number...">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">BASE CITY <span class="text-accent">*</span></label>
                                        <input type="text" class="form-control bg-light border-0 py-3 px-4 fw-600 rounded-4" name="reporter_city" required>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">BASE STATE <span class="text-accent">*</span></label>
                                        <input type="text" class="form-control bg-light border-0 py-3 px-4 fw-600 rounded-4" name="reporter_state" required>
                                    </div>
                                </div>
                            </div>

                            <!-- Section: Visual & Documents -->
                            <div class="glass-card p-5 border-0 bg-white shadow-sm animate__animated animate__fadeInLeft animate__delay-1s">
                                <div class="d-flex align-items-center gap-4 mb-5">
                                    <div class="bg-accent bg-opacity-10 text-accent rounded-4 d-flex align-items-center justify-content-center shadow-sm" style="width: 50px; height: 50px;">
                                        <i class="fa-solid fa-fingerprint fs-4"></i>
                                    </div>
                                    <h4 class="fw-800 mb-0">Validation Data</h4>
                                </div>

                                <div class="row g-4">
                                    <div class="col-12">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">HIGH-RES PROFILE IMAGE <span class="text-accent">*</span></label>
                                        <div class="drop-zone p-4 bg-light rounded-4 border-dashed text-center">
                                            <input type="file" class="form-control border-0 bg-transparent shadow-none" name="photo" accept="image/*" required>
                                            <div class="small opacity-50 mt-1 fw-600">Primary visual for AI identification</div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">OFFICIAL FIR DOCUMENT <span class="text-accent">*</span></label>
                                        <div class="drop-zone p-4 bg-light rounded-4 border-dashed text-center">
                                            <input type="file" class="form-control border-0 bg-transparent shadow-none" name="fir_copy" accept=".pdf,image/*" required>
                                            <div class="small opacity-50 mt-1 fw-600">Authority validation file required</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Right Pillar: Subject Details -->
                        <div class="col-lg-6">
                            <div class="glass-card p-5 border-0 bg-white shadow-sm animate__animated animate__fadeInRight">
                                <div class="d-flex align-items-center gap-4 mb-5">
                                    <div class="bg-success bg-opacity-10 text-success rounded-4 d-flex align-items-center justify-content-center shadow-sm" style="width: 50px; height: 50px;">
                                        <i class="fa-solid fa-magnifying-glass-chart fs-4"></i>
                                    </div>
                                    <h4 class="fw-800 mb-0">Individual Profile</h4>
                                </div>

                                <div class="row g-4">
                                    <div class="col-12">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">FULL LEGAL NAME <span class="text-accent">*</span></label>
                                        <input type="text" class="form-control bg-light border-0 py-3 px-4 fw-800 rounded-4 text-primary" name="name" required placeholder="Subject full name...">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">ACCURATE AGE <span class="text-accent">*</span></label>
                                        <input type="number" class="form-control bg-light border-0 py-3 px-4 fw-600 rounded-4" name="age" required min="1" max="115">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">GENDER <span class="text-accent">*</span></label>
                                        <select class="form-select bg-light border-0 py-3 px-4 fw-600 rounded-4" name="gender" required>
                                            <option value="">Select</option>
                                            <option value="Male">Male</option>
                                            <option value="Female">Female</option>
                                            <option value="Non-binary">Non-binary</option>
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">HEIGHT (METRIC/IMP)</label>
                                        <input type="text" class="form-control bg-light border-0 py-3 px-4 fw-600 rounded-4" name="height" placeholder="e.g. 5ft 10in">
                                    </div>
                                    <div class="col-md-6">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">COMPLEXION SPECTRUM</label>
                                        <select class="form-select bg-light border-0 py-3 px-4 fw-600 rounded-4" name="complexion">
                                            <option value="">Choose Scale</option>
                                            <option value="Fair">Fair Spectrum</option>
                                            <option value="Wheatish">Wheatish Spectrum</option>
                                            <option value="Dark">Dark Spectrum</option>
                                        </select>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">DETECTION DATE <span class="text-accent">*</span></label>
                                        <input type="date" class="form-control bg-light border-0 py-3 px-4 fw-600 rounded-4 text-primary" name="date_missing" required>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">LAST KNOWN DETECTION COORDS <span class="text-accent">*</span></label>
                                        <div class="position-relative">
                                            <i class="fa-solid fa-location-dot position-absolute top-50 start-0 translate-middle-y ms-3 text-accent opacity-50"></i>
                                            <input type="text" class="form-control bg-light border-0 ps-5 py-3 fw-600 rounded-4" name="last_seen_location" required placeholder="Area name, Landmarker, City...">
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">MEDICAL CONDITIONS / ALERTS</label>
                                        <textarea class="form-control bg-light border-0 py-3 px-4 fw-600 rounded-4" name="medical_condition" rows="2" placeholder="Mental health alerts, medications, etc."></textarea>
                                    </div>
                                    <div class="col-12">
                                        <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">LAST REPORTED ATTIRE & ATTACHMENTS</label>
                                        <input type="text" class="form-control bg-light border-0 py-3 px-4 fw-600 rounded-4" name="clothes" placeholder="Color, items, bags...">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Footer Control: Declaration -->
                        <div class="col-12">
                            <div class="glass-card p-5 bg-dark text-white border-0 shadow-lg animate__animated animate__fadeInUp">
                                <div class="row align-items-center g-4">
                                    <div class="col-lg-8">
                                        <div class="form-check custom-check">
                                            <input class="form-check-input shadow-none bg-transparent" type="checkbox" id="declaration_check" name="genuine_declaration" required style="width: 25px; height: 25px; border-color: var(--primary);">
                                            <label class="form-check-label ms-3 fs-5 fw-600" for="declaration_check">
                                                Intelligence declaration confirmed. Information provided is validated and subject to legal scrutiny.
                                            </label>
                                        </div>
                                        <p class="text-white text-opacity-50 small mt-3 mb-0"><i class="fa-solid fa-shield-halved me-2"></i> FindMissing protocol enforces strict penalties for false case filing according to IPC guidelines.</p>
                                    </div>
                                    <div class="col-lg-4 text-lg-end">
                                        <button type="submit" class="btn btn-premium btn-lg w-100 py-3 fs-5">TRANSMIT TO GLOBAL NETWORK <i class="fa-solid fa-chevron-right ms-2 fs-6"></i></button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
    .letter-spacing-1 { letter-spacing: 1px; }
    .border-dashed { border: 2px dashed #cbd5e1; }
    .custom-check .form-check-input:checked { background-color: var(--primary) !important; }
</style>
@endsection
