<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="FindMissing - The most trusted community platform for reuniting missing people with their loved ones.">
    <title>@yield('title', 'FindMissing | Reconnecting Lives')</title>
    
    <!-- Premium Typography -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Outfit:wght@300;400;500;600;700;800&family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome Pro -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Animate.css for smooth entries -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>

    <style>
        :root {
            --primary: #6366f1;
            --primary-dark: #4f46e5;
            --primary-light: #818cf8;
            --secondary: #64748b;
            --accent: #f43f5e;
            --glass: rgba(255, 255, 255, 0.8);
            --glass-border: rgba(255, 255, 255, 0.4);
            --depth-shadow: 0 10px 40px -10px rgba(0, 0, 0, 0.1);
            --card-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1), 0 2px 4px -1px rgba(0, 0, 0, 0.06);
            --bg-soft: #f8fafc;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--bg-soft);
            color: #1e293b;
            overflow-x: hidden;
            letter-spacing: -0.015em;
        }

        h1, h2, h3, h4, h5, h6, .navbar-brand, .fw-outfit {
            font-family: 'Outfit', sans-serif;
        }

        /* Ultra Premium Navbar */
        .navbar {
            backdrop-filter: blur(15px);
            background: rgba(255, 255, 255, 0.75);
            border-bottom: 1px solid var(--glass-border);
            padding: 1.25rem 0;
            transition: all 0.3s ease;
        }
        
        .navbar.scrolled {
            padding: 0.8rem 0;
            background: rgba(255, 255, 255, 0.95);
            box-shadow: 0 4px 20px rgba(0,0,0,0.03);
        }

        .navbar-brand {
            font-weight: 800;
            font-size: 1.6rem;
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            letter-spacing: -1px;
        }

        .nav-link {
            font-weight: 500;
            color: #475569;
            padding: 0.5rem 1.2rem !important;
            transition: all 0.2s ease;
            position: relative;
        }

        .nav-link:hover, .nav-link.active {
            color: var(--primary);
        }

        .nav-link::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            width: 0;
            height: 2px;
            background: var(--primary);
            transition: all 0.3s ease;
            transform: translateX(-50%);
        }

        .nav-link:hover::after, .nav-link.active::after {
            width: 30px;
        }

        /* Premium Mobile Menu Fixes */
        @media (max-width: 991.98px) {
            .navbar-collapse {
                background: #ffffff;
                position: absolute;
                top: 100%;
                left: 1rem;
                right: 1rem;
                padding: 1.5rem;
                border-radius: 24px;
                box-shadow: 0 20px 50px rgba(0,0,0,0.1);
                margin-top: 1rem;
                border: 1px solid rgba(0,0,0,0.05);
                backdrop-filter: blur(20px);
            }
            .navbar-nav {
                text-align: center;
            }
            .nav-item {
                margin: 0.5rem 0;
            }
            .nav-link {
                padding: 0.8rem !important;
                font-size: 1.1rem;
                font-weight: 700;
                color: #1e293b;
            }
            .nav-link::after { display: none; }
            
            /* Custom Toggler Icon */
            .navbar-toggler {
                width: 40px;
                height: 40px;
                padding: 0;
                display: flex;
                flex-direction: column;
                justify-content: center;
                align-items: center;
                gap: 5px;
            }
            .navbar-toggler span {
                width: 25px;
                height: 2px;
                background: var(--primary);
                display: block;
                border-radius: 2px;
                transition: 0.3s;
            }
            .navbar-toggler[aria-expanded="true"] span:nth-child(1) { transform: rotate(45deg) translate(5px, 5px); }
            .navbar-toggler[aria-expanded="true"] span:nth-child(2) { opacity: 0; }
            .navbar-toggler[aria-expanded="true"] span:nth-child(3) { transform: rotate(-45deg) translate(5px, -5px); }
        }

        /* Premium Buttons */
        .btn-premium {
            background: linear-gradient(135deg, var(--primary) 0%, var(--primary-dark) 100%);
            color: white;
            border: none;
            padding: 0.8rem 2rem;
            border-radius: 100px;
            font-weight: 600;
            box-shadow: 0 10px 20px -5px rgba(99, 102, 241, 0.4);
            transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
        }

        .btn-premium:hover {
            transform: translateY(-3px);
            box-shadow: 0 15px 25px -5px rgba(99, 102, 241, 0.5);
            color: white;
        }

        .btn-outline-premium {
            border: 2px solid var(--primary);
            color: var(--primary);
            padding: 0.7rem 2rem;
            border-radius: 100px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-outline-premium:hover {
            background: var(--primary);
            color: white;
            transform: translateY(-2px);
        }

        /* Global Cards & Components */
        .glass-card {
            background: var(--glass);
            backdrop-filter: blur(10px);
            border: 1px solid var(--glass-border);
            border-radius: 24px;
            box-shadow: var(--depth-shadow);
        }

        .hover-lift {
            transition: all 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
        }

        .hover-lift:hover {
            transform: translateY(-8px);
            box-shadow: 0 20px 40px rgba(0,0,0,0.08);
        }

        /* Footer Aesthetics */
        .footer {
            background: #0f172a;
            color: #cbd5e1;
            padding: 6rem 0 3rem;
            position: relative;
            overflow: hidden;
        }

        .footer::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 4px;
            background: linear-gradient(90deg, var(--primary), var(--accent), var(--primary));
        }

        .footer h5 { color: white; margin-bottom: 2rem; }
        .footer a { color: #cbd5e1; text-decoration: none; transition: 0.3s; }
        .footer a:hover { color: var(--primary-light); padding-left: 5px; }

        /* Custom Scrollbar */
        ::-webkit-scrollbar { width: 10px; }
        ::-webkit-scrollbar-track { background: #f1f1f1; }
        ::-webkit-scrollbar-thumb { background: #cbd5e1; border-radius: 5px; }
        ::-webkit-scrollbar-thumb:hover { background: #94a3b8; }

        /* Animations */
        @keyframes fadeInScale {
            from { opacity: 0; transform: scale(0.95); }
            to { opacity: 1; transform: scale(1); }
        }

        .fade-in-scale {
            animation: fadeInScale 0.8s ease-out forwards;
        }

        /* Responsive Fixes */
        @media (max-width: 991px) {
            .navbar-collapse {
                background: white;
                margin-top: 1rem;
                padding: 1.5rem;
                border-radius: 20px;
                box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            }
        }
    </style>
    @stack('css')
</head>
<body class="d-flex flex-column min-vh-100">

    <!-- Premium Navigation -->
    <nav class="navbar navbar-expand-lg sticky-top">
        <div class="container">
            <a class="navbar-brand animate__animated animate__fadeInLeft" href="{{ url('/') }}">
                <i class="fa-solid fa-circle-nodes me-2"></i>FindMissing
            </a>
            
            <button class="navbar-toggler border-0 shadow-none" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span></span>
                <span></span>
                <span></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item">
                        <a class="nav-link {{ request()->is('/') ? 'active' : '' }}" href="{{ url('/') }}">Home</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->is('missing*') ? 'active' : '' }}" href="{{ url('/missing') }}">Explorer</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#how-it-works">Safety Center</a>
                    </li>
                    
                    @auth
                        <li class="nav-item dropdown ms-lg-4">
                            <a class="nav-link dropdown-toggle d-flex align-items-center bg-light rounded-pill px-3 py-2" href="#" id="userDropdown" role="button" data-bs-toggle="dropdown">
                                <div class="bg-primary text-white rounded-circle me-2 d-flex align-items-center justify-content-center" style="width: 25px; height: 25px; font-size: 0.7rem;">
                                    {{ substr(Auth::user()->name, 0, 1) }}
                                </div>
                                <span class="small fw-600">{{ Auth::user()->name }}</span>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end border-0 shadow-lg animate__animated animate__fadeInUp animate__faster mt-2 py-2">
                                @if(Auth::user()->is_admin)
                                    <li><a class="dropdown-item py-2 fw-600 text-info" href="{{ url('/admin') }}"><i class="fa-solid fa-shield-halved me-2"></i>Admin Vault</a></li>
                                    <li><hr class="dropdown-divider opacity-50"></li>
                                @endif
                                <li><a class="dropdown-item py-2" href="{{ url('/dashboard') }}"><i class="fa-solid fa-gauge me-2 opacity-50"></i>Dashboard</a></li>
                                <li><a class="dropdown-item py-2" href="{{ url('/dashboard/profile') }}"><i class="fa-solid fa-user-gear me-2 opacity-50"></i>Settings</a></li>
                                <li><hr class="dropdown-divider opacity-50"></li>
                                <li>
                                    <form method="POST" action="{{ route('logout') }}">
                                        @csrf
                                        <button type="submit" class="dropdown-item text-danger py-2"><i class="fa-solid fa-power-off me-2"></i>Logout</button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                        <li class="nav-item ms-lg-3">
                             <a class="btn btn-premium btn-sm" href="{{ url('/missing/create') }}"><i class="fa-solid fa-plus me-1"></i>Report</a>
                        </li>
                    @else
                        <li class="nav-item ms-lg-4">
                            <a class="nav-link fw-700 text-dark" href="{{ url('/login') }}">Sign In</a>
                        </li>
                        <li class="nav-item ms-lg-2 mt-3 mt-lg-0">
                            <a class="btn btn-premium btn-lg w-100 px-lg-4 px-5 py-lg-2 py-3 shadow-lg" href="{{ url('/register') }}">Get Started <i class="fa-solid fa-arrow-right-long ms-2 d-lg-none"></i></a>
                        </li>
                    @endauth
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content Area -->
    <main class="flex-grow-1">
        @yield('content')
    </main>

    <!-- Ultra Premium Footer -->
    <footer class="footer mt-auto">
        <div class="container">
            <div class="row g-5">
                <div class="col-lg-4">
                    <div class="mb-4">
                        <span class="h3 fw-800 text-white"><i class="fa-solid fa-circle-nodes me-2 text-primary"></i>FindMissing</span>
                    </div>
                    <p class="mb-4 opacity-75">Establishing the first decentralized community-based missing persons verification platform. Powered by volunteers and verified data.</p>
                    <div class="social-links d-flex gap-3">
                        <a href="#" class="bg-white bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;"><i class="fa-brands fa-twitter text-white"></i></a>
                        <a href="#" class="bg-white bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;"><i class="fa-brands fa-instagram text-white"></i></a>
                        <a href="#" class="bg-white bg-opacity-10 rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;"><i class="fa-brands fa-facebook-f text-white"></i></a>
                    </div>
                </div>
                
                <div class="col-lg-2 col-md-6">
                    <h6 class="text-uppercase fw-800 mb-4 letter-spacing-1 text-primary-light">Platform</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="{{ url('/missing') }}">Search Registry</a></li>
                        <li class="mb-2"><a href="{{ url('/missing/create') }}">File a Report</a></li>
                        <li class="mb-2"><a href="#">Verification Process</a></li>
                    </ul>
                </div>
                
                <div class="col-lg-2 col-md-6">
                    <h6 class="text-uppercase fw-800 mb-4 letter-spacing-1 text-primary-light">Impact</h6>
                    <ul class="list-unstyled">
                        <li class="mb-2"><a href="#">Resolved Cases</a></li>
                        <li class="mb-2"><a href="#">How it Works</a></li>
                        <li class="mb-2"><a href="#">Volunteering</a></li>
                    </ul>
                </div>

                <div class="col-lg-4">
                    <div class="rounded-4 p-4 border border-white border-opacity-10" style="background: rgba(255, 255, 255, 0.05);">
                        <h6 class="fw-800 mb-3 text-white">Emergency Support</h6>
                        <div class="d-flex align-items-start mb-3">
                            <i class="fa-solid fa-shield-heart text-accent me-3 mt-1"></i>
                            <div>
                                <div class="text-white small fw-bold">Global Helpline</div>
                                <div class="text-white small opacity-75">Call 1090/100 (Pan India)</div>
                            </div>
                        </div>
                        <p class="small text-white opacity-50 mb-0">Note: We are a platform to facilitate search, not a direct emergency responder. Always contact police first.</p>
                    </div>
                </div>
            </div>
            
            <div class="pt-5 mt-5 border-top border-white border-opacity-10 d-flex flex-column flex-md-row justify-content-between align-items-center gap-3">
                <div class="small opacity-50">&copy; {{ date('Y') }} FindMissing Platform. Meticulously designed for humanity.</div>
                <div class="d-flex gap-4 small fw-500">
                    <a href="#" class="opacity-50">Privacy Protocol</a>
                    <a href="#" class="opacity-50">Terms of Use</a>
                    <a href="#" class="opacity-50">Legal Verification</a>
                </div>
            </div>
        </div>
    </footer>

    <!-- Premium Scripts -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script>
        $(window).scroll(function() {
            if ($(this).scrollTop() > 50) {
                $('.navbar').addClass('scrolled');
            } else {
                $('.navbar').removeClass('scrolled');
            }
        });
    </script>
    @stack('scripts')
</body>
</html>
