@extends('layouts.app')

@section('content')
<div class="bg-soft min-vh-100 py-5">
    <div class="container pt-4">
        <div class="row">
            <!-- Sidebar Navigation -->
            <div class="col-lg-3 mb-4">
                <button class="btn btn-white w-100 d-lg-none shadow-sm border rounded-pill py-3 fw-800 mb-4" type="button" data-bs-toggle="collapse" data-bs-target="#dashboardMenu">
                    <i class="fa-solid fa-bars-staggered me-2 text-primary"></i> TERMINAL MENU
                </button>
                <div class="collapse d-lg-block" id="dashboardMenu">
                    @include('dashboard.partials.sidebar')
                </div>
            </div>

            <!-- Content Area -->
            <div class="col-lg-9 animate__animated animate__fadeIn">
                <!-- Case Context Header -->
                <div class="glass-card p-4 border-0 bg-dark text-white shadow-lg mb-5 overflow-hidden position-relative">
                    <div class="position-absolute top-0 end-0 p-5 opacity-10">
                        <i class="fa-solid fa-file-invoice fa-5x"></i>
                    </div>
                    <div class="row align-items-center g-4">
                        <div class="col-auto">
                            <img src="{{ asset('storage/' . $case->photo) }}" class="rounded-4 object-fit-cover shadow-lg border border-white border-opacity-20" style="width: 80px; height: 80px;">
                        </div>
                        <div class="col">
                            <h3 class="fw-800 mb-1">Intelligence Leads: <span class="text-primary-light">{{ $case->name }}</span></h3>
                            <div class="d-flex align-items-center gap-3">
                                <span class="badge bg-success bg-opacity-20 text-success border border-success border-opacity-20 rounded-pill px-3 py-1 fw-800 small text-uppercase letter-spacing-1" style="font-size: 0.6rem;">CASE ACTIVE</span>
                                <div class="vr bg-white opacity-20" style="height: 15px;"></div>
                                <span class="small opacity-50 fw-600">ID-V{{ $case->id }} • FILED {{ $case->created_at->format('M d, Y') }}</span>
                            </div>
                        </div>
                        <div class="col-lg-auto text-lg-end">
                            <a href="{{ route('missing.show', $case->id) }}" class="btn btn-outline-light btn-sm rounded-pill px-4 py-2 border-opacity-25 fw-800" style="font-size: 0.7rem;">VIEW PUBLIC FILE</a>
                        </div>
                    </div>
                </div>

                <!-- Verified Leads List -->
                <div class="row g-4">
                    @forelse($tips as $tip)
                    <div class="col-12 animate__animated animate__fadeInUp">
                        <div class="glass-card p-0 border-0 bg-white shadow-sm overflow-hidden hover-lift">
                            <div class="row g-0">
                                <div class="col-md-8 p-5">
                                    <div class="d-flex align-items-center gap-3 mb-4">
                                        <div class="bg-primary bg-opacity-10 text-primary rounded-pill px-3 py-1 fw-800 small letter-spacing-1 text-uppercase" style="font-size: 0.6rem;">Sighting Report</div>
                                        <div class="small fw-800 text-muted opacity-50">{{ $tip->created_at->format('M d, Y • H:i') }}</div>
                                    </div>
                                    <div class="p-4 bg-light rounded-4 mb-4">
                                        <p class="fs-5 text-dark fw-600 mb-0 opacity-75 line-height-1-6">{{ $tip->message }}</p>
                                    </div>
                                    @if($tip->contact_info)
                                    <div class="d-flex align-items-center gap-2 mb-4">
                                        <i class="fa-solid fa-id-card-clip text-primary"></i>
                                        <span class="small fw-800 text-muted text-uppercase letter-spacing-1">Handshake Node:</span>
                                        <span class="badge bg-primary bg-opacity-10 text-primary rounded-pill px-3 py-1 fw-800">{{ $tip->contact_info }}</span>
                                    </div>
                                    @endif
                                </div>
                                <div class="col-md-4 bg-light d-flex align-items-center justify-content-center p-4">
                                    @if($tip->evidence)
                                        <div class="position-relative w-100">
                                            <img src="{{ asset('storage/' . $tip->evidence) }}" class="w-100 rounded-4 shadow-lg object-fit-cover" style="height: 250px;">
                                            <div class="position-absolute bottom-0 start-0 m-3 px-3 py-1 bg-black bg-opacity-70 text-white rounded-pill fw-800 extra-small">ATTACHED EVIDENCE</div>
                                        </div>
                                    @else
                                        <div class="text-center opacity-25">
                                            <i class="fa-solid fa-camera-slash fa-3x mb-3"></i>
                                            <div class="fw-800 small text-uppercase">No Visual Proof</div>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="col-12 text-center py-5">
                        <div class="glass-card p-5 bg-white border-0 shadow-sm animate__animated animate__zoomIn">
                            <i class="fa-solid fa-radar fa-4x text-primary opacity-25 mb-4 d-block"></i>
                            <h4 class="fw-800">Operational Silence</h4>
                            <p class="text-secondary opacity-75 mb-0">No intelligence data has been transmitted back from the network registry yet.</p>
                        </div>
                    </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .letter-spacing-1 { letter-spacing: 1px; }
    .extra-small { font-size: 0.65rem; }
    .line-height-1-6 { line-height: 1.6; }
</style>
@endsection
