@extends('layouts.app')

@section('content')
<div class="bg-soft min-vh-100 py-5">
    <div class="container pt-4">
        <div class="row">
            <!-- Sidebar Navigation -->
            <div class="col-lg-3 mb-4">
                <button class="btn btn-white w-100 d-lg-none shadow-sm border rounded-pill py-3 fw-800 mb-4" type="button" data-bs-toggle="collapse" data-bs-target="#dashboardMenu">
                    <i class="fa-solid fa-bars-staggered me-2 text-primary"></i> TERMINAL MENU
                </button>
                <div class="collapse d-lg-block" id="dashboardMenu">
                    @include('dashboard.partials.sidebar')
                </div>
            </div>

            <!-- Content Area -->
            <div class="col-lg-9 animate__animated animate__fadeIn">
                <div class="glass-card overflow-hidden border-0 bg-white shadow-sm mb-5">
                    <div class="p-5 border-bottom border-light">
                        <h2 class="fw-800 mb-1">Node <span class="text-primary">Settings.</span></h2>
                        <p class="text-secondary opacity-75 mb-0">Manage your operational identity and encrypted data access.</p>
                    </div>
                    
                    <div class="card-body p-5">
                        @if(session('success'))
                            <div class="alert alert-success border-0 shadow-sm rounded-4 mb-5 animate__animated animate__bounceIn">
                                <div class="d-flex align-items-center gap-3">
                                    <i class="fa-solid fa-circle-check fs-4"></i>
                                    <div>
                                        <div class="fw-800">Operational Update Successful</div>
                                        <div class="small opacity-75 fw-600">{{ session('success') }}</div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        <form action="{{ route('dashboard.profile.update') }}" method="POST">
                            @csrf
                            <div class="row g-5">
                                <div class="col-lg-6">
                                    <div class="p-4 bg-light rounded-4 h-100 border border-light">
                                        <div class="d-flex align-items-center gap-3 mb-4">
                                            <div class="bg-primary bg-opacity-10 text-primary rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                <i class="fa-solid fa-user-check"></i>
                                            </div>
                                            <h5 class="fw-800 mb-0 d-flex align-items-center text-uppercase letter-spacing-1 small">Primary Identity</h5>
                                        </div>
                                        
                                        <div class="mb-4">
                                            <label class="form-label small fw-800 text-muted opacity-50 mb-2">NETWORK DISPLAY NAME</label>
                                            <div class="position-relative">
                                                <i class="fa-solid fa-signature position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                                <input type="text" name="name" class="form-control border-0 bg-white py-3 ps-5 fw-800 rounded-4 shadow-none" value="{{ old('name', $user->name) }}" required>
                                            </div>
                                            @error('name') <small class="text-danger extra-small">{{ $message }}</small> @enderror
                                        </div>

                                        <div class="mb-0">
                                            <label class="form-label small fw-800 text-muted opacity-50 mb-2">OFFICIAL COMMUNICATION LINE</label>
                                            <div class="position-relative">
                                                <i class="fa-solid fa-mobile-screen position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                                <input type="text" name="mobile" class="form-control border-0 bg-white py-3 ps-5 fw-800 rounded-4 shadow-none" value="{{ old('mobile', $user->mobile) }}" placeholder="e.g. +91 98765 43210">
                                            </div>
                                            @error('mobile') <small class="text-danger extra-small">{{ $message }}</small> @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-6">
                                    <div class="p-4 bg-light rounded-4 h-100 border border-light">
                                        <div class="d-flex align-items-center gap-3 mb-4">
                                            <div class="bg-dark bg-opacity-10 text-dark rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                                <i class="fa-solid fa-fingerprint"></i>
                                            </div>
                                            <h5 class="fw-800 mb-0 d-flex align-items-center text-uppercase letter-spacing-1 small">Account DNA</h5>
                                        </div>
                                        
                                        <div class="mb-4">
                                            <label class="form-label small fw-800 text-muted opacity-50 mb-2">VERIFIED EMAIL (SYSTEM ID)</label>
                                            <div class="position-relative">
                                                <i class="fa-solid fa-envelope-shield position-absolute top-50 start-0 translate-middle-y ms-3 text-muted"></i>
                                                <input type="email" class="form-control border-0 bg-white bg-opacity-50 py-3 ps-5 fw-800 rounded-4 shadow-none" value="{{ $user->email }}" disabled style="cursor: not-allowed;">
                                            </div>
                                            <div class="extra-small text-muted mt-2 fw-600 opacity-50"><i class="fa-solid fa-circle-info me-1"></i> System IDs are immutable for security validation.</div>
                                        </div>

                                        <div class="mb-0">
                                            <label class="form-label small fw-800 text-muted opacity-50 mb-2">NETWORK ENTRY DATE</label>
                                            <div class="p-3 bg-white bg-opacity-50 rounded-4 border-0">
                                                <div class="d-flex justify-content-between align-items-center">
                                                    <span class="small fw-800 text-success"><i class="fa-solid fa-shield-heart me-2"></i>ACTIVATED</span>
                                                    <span class="small fw-800 text-dark">{{ $user->created_at->format('M d, Y') }}</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-12 text-end pt-4">
                                    <button type="submit" class="btn btn-premium btn-lg px-5 py-3 rounded-pill fw-800 shadow-lg d-inline-flex align-items-center">
                                        UPDATE PROTOCOL INFO <i class="fa-solid fa-chevron-right ms-3"></i>
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Secure Data Notice -->
                <div class="glass-card p-4 bg-dark text-white border-0 shadow-lg animate__animated animate__fadeInUp animate__delay-1s">
                    <div class="row align-items-center g-4">
                        <div class="col-auto">
                            <div class="rounded-circle bg-primary bg-opacity-20 d-flex align-items-center justify-content-center shadow-lg" style="width: 60px; height: 60px;">
                                <i class="fa-solid fa-shield-halved text-primary fs-3"></i>
                            </div>
                        </div>
                        <div class="col">
                            <h6 class="fw-800 mb-1">Data Sovereignty & Encryption</h6>
                            <p class="text-white text-opacity-50 extra-small mb-0 fw-600">Your profile data is protected under FindMissing's advanced encryption layer. We strictly adhere to DPA/GDPR compliance for all node members.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .letter-spacing-1 { letter-spacing: 1px; }
    .extra-small { font-size: 0.65rem; }
    .btn-premium {
        box-shadow: 0 10px 40px -10px rgba(99, 102, 241, 0.5) !important;
    }
</style>
@endsection
