<div class="glass-card overflow-hidden border-0 shadow-sm bg-white mb-4 animate__animated animate__fadeInLeft">
    <div class="p-4 border-bottom border-light">
        <div class="d-flex align-items-center gap-3">
            <div class="bg-primary bg-opacity-10 text-primary rounded-circle d-flex align-items-center justify-content-center" style="width: 45px; height: 45px;">
                <i class="fa-solid fa-user-gear"></i>
            </div>
            <div>
                <div class="small fw-800 text-muted text-uppercase letter-spacing-1" style="font-size: 0.6rem;">Protocol Member</div>
                <div class="fw-800 text-dark">{{ Auth::user()->name }}</div>
            </div>
        </div>
    </div>
    <div class="list-group list-group-flush border-0">
        <a href="{{ route('dashboard.index') }}" class="list-group-item list-group-item-action py-3 px-4 border-0 d-flex align-items-center justify-content-between {{ request()->routeIs('dashboard.index') ? 'bg-primary bg-opacity-10 text-primary fw-800' : 'text-secondary opacity-75 fw-600' }}">
            <span><i class="fa-solid fa-layer-group me-3"></i>Case Monitoring</span>
            @if(request()->routeIs('dashboard.index')) <i class="fa-solid fa-chevron-right small"></i> @endif
        </a>
        <a href="{{ route('dashboard.messages') }}" class="list-group-item list-group-item-action py-3 px-4 border-0 d-flex align-items-center justify-content-between {{ request()->routeIs('dashboard.messages') ? 'bg-primary bg-opacity-10 text-primary fw-800' : 'text-secondary opacity-75 fw-600' }}">
            <span><i class="fa-solid fa-satellite-dish me-3"></i>Intelligence Leads</span>
            @php
                $totalTips = \App\Models\Tip::whereHas('missingPerson', function($q) {
                    $q->where('user_id', Auth::id());
                })->count();
            @endphp
            @if($totalTips > 0)
                <span class="badge bg-primary text-white rounded-pill px-2 py-1 small">{{ $totalTips }}</span>
            @endif
        </a>
        <a href="{{ route('dashboard.profile') }}" class="list-group-item list-group-item-action py-3 px-4 border-0 d-flex align-items-center justify-content-between {{ request()->routeIs('dashboard.profile') ? 'bg-primary bg-opacity-10 text-primary fw-800' : 'text-secondary opacity-75 fw-600' }}">
            <span><i class="fa-solid fa-shield-halved me-3"></i>Node Settings</span>
            @if(request()->routeIs('dashboard.profile')) <i class="fa-solid fa-chevron-right small"></i> @endif
        </a>
    </div>
</div>

<div class="glass-card p-4 border-0 bg-dark text-white shadow-lg animate__animated animate__fadeInLeft animate__delay-1s">
    <div class="d-flex align-items-center gap-3 mb-3">
        <i class="fa-solid fa-circle-question text-primary-light fs-4"></i>
        <h6 class="fw-800 mb-0">Help Desk</h6>
    </div>
    <p class="extra-small opacity-50 mb-3">Require technical assistance or legal guidance regarding a filing?</p>
    <div class="d-grid gap-2">
        <a href="#" class="btn btn-outline-light btn-sm rounded-pill fw-800 border-opacity-25" style="font-size: 0.7rem;">CONTACT SUPPORT</a>
    </div>
</div>

<style>
    .letter-spacing-1 { letter-spacing: 1px; }
    .extra-small { font-size: 0.65rem; }
    .list-group-item-action:hover {
        background-color: #f8fafc;
        padding-left: 2rem !important;
        transition: all 0.3s cubic-bezier(0.175, 0.885, 0.32, 1.275);
    }
</style>
