@extends('layouts.app')

@section('content')
<div class="auth-wrapper d-flex align-items-center justify-content-center min-vh-100 position-relative overflow-hidden py-5" style="background: #f8fafc;">
    <!-- Animated Blobs -->
    <div class="blob position-absolute bg-primary opacity-10 rounded-circle" style="width: 500px; height: 500px; top: -10%; left: -10%; filter: blur(100px); animation: float 20s infinite;"></div>
    <div class="blob position-absolute bg-success opacity-10 rounded-circle" style="width: 400px; height: 400px; bottom: -5%; right: -5%; filter: blur(100px); animation: float 15s infinite reverse;"></div>

    <div class="container animate__animated animate__fadeIn">
        <div class="row justify-content-center">
            <div class="col-md-7 col-lg-6">
                <div class="glass-card shadow-lg border-0 bg-white p-2" style="border-radius: 32px;">
                    <div class="card-body p-5">
                        <div class="text-center mb-5">
                            <div class="d-inline-flex align-items-center justify-content-center bg-success bg-opacity-10 text-success rounded-circle mb-4" style="width: 80px; height: 80px;">
                                <i class="fa-solid fa-user-plus fs-2"></i>
                            </div>
                            <h2 class="fw-800 text-dark mb-1">Create Account</h2>
                            <p class="text-secondary small fw-600 opacity-75">Join our community to help find missing persons</p>
                        </div>

                        <form method="POST" action="{{ route('register') }}">
                            @csrf

                            @if($errors->any())
                                <div class="p-4 bg-danger bg-opacity-5 rounded-4 border border-danger border-opacity-10 mb-5 animate__animated animate__shakeX">
                                    <div class="text-danger small fw-800"><i class="fa-solid fa-circle-exclamation me-2"></i>Registration Error</div>
                                    <ul class="mb-0 text-danger extra-small opacity-75">
                                        @foreach($errors->all() as $error)
                                            <li>{{ $error }}</li>
                                        @endforeach
                                    </ul>
                                </div>
                            @endif

                            <div class="mb-4">
                                <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">FULL NAME</label>
                                <div class="position-relative">
                                    <i class="fa-solid fa-user position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                    <input type="text" class="form-control bg-light border-0 ps-5 py-3 fw-600 rounded-4 shadow-none @error('name') is-invalid @enderror" name="name" value="{{ old('name') }}" required placeholder="John Doe">
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">EMAIL ADDRESS</label>
                                    <div class="position-relative">
                                        <i class="fa-solid fa-envelope position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                        <input type="email" class="form-control bg-light border-0 ps-5 py-3 fw-600 rounded-4 shadow-none" name="email" value="{{ old('email') }}" required placeholder="name@example.com">
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">MOBILE NUMBER</label>
                                    <div class="position-relative">
                                        <i class="fa-solid fa-mobile-screen position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                        <input type="tel" class="form-control bg-light border-0 ps-5 py-3 fw-600 rounded-4 shadow-none" name="mobile" value="{{ old('mobile') }}" required placeholder="10-digit number">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-4">
                                    <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">PASSWORD</label>
                                    <div class="position-relative">
                                        <i class="fa-solid fa-key position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                        <input type="password" class="form-control bg-light border-0 ps-5 py-3 fw-600 rounded-4 shadow-none" name="password" required placeholder="••••••••">
                                    </div>
                                </div>
                                <div class="col-md-6 mb-4">
                                    <label class="form-label small fw-800 text-muted text-uppercase letter-spacing-1 mb-2">CONFIRM PASSWORD</label>
                                    <div class="position-relative">
                                        <i class="fa-solid fa-shield-check position-absolute top-50 start-0 translate-middle-y ms-3 text-primary opacity-50"></i>
                                        <input type="password" class="form-control bg-light border-0 ps-5 py-3 fw-600 rounded-4 shadow-none" name="password_confirmation" required placeholder="••••••••">
                                    </div>
                                </div>
                            </div>

                            <div class="mb-5">
                                <div class="form-check custom-check">
                                    <input type="checkbox" class="form-check-input shadow-none bg-transparent" id="declaration" name="declaration" required style="width: 22px; height: 22px; border-radius: 6px; border-color: #cbd5e1;">
                                    <label class="form-check-label small text-secondary fw-600 ms-2 mt-1" for="declaration">
                                        I confirm all the information provided is accurate and genuine.
                                    </label>
                                </div>
                            </div>

                            <div class="d-grid mb-4">
                                <button type="submit" class="btn btn-premium btn-lg py-3 fw-800">
                                    REGISTER NOW <i class="fa-solid fa-circle-check ms-2"></i>
                                </button>
                            </div>

                            <div class="text-center">
                                <span class="text-secondary small fw-600">Already have an account?</span> 
                                <a href="{{ url('/login') }}" class="text-primary small fw-800 text-decoration-none ms-1">LOGIN HERE</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    @keyframes float {
        0%, 100% { transform: translate(0, 0); }
        50% { transform: translate(20px, 30px); }
    }
    .letter-spacing-1 { letter-spacing: 1px; }
    .extra-small { font-size: 0.65rem; }
    .custom-check .form-check-input:checked { background-color: var(--primary) !important; border-color: var(--primary) !important; }
</style>
@endsection
