@extends('layouts.admin')

@section('admin_content')
<div class="row mb-4 align-items-center">
    <div class="col-8">
        <a href="{{ route('admin.users.index') }}" class="text-decoration-none small text-muted mb-2 d-block"><i class="fa-solid fa-arrow-left"></i> Back to Users</a>
        <h4 class="fw-800 mb-0">User Profile: {{ $user->name }}</h4>
    </div>
    <div class="col-4 text-end">
        @if($user->is_blocked)
            <span class="badge bg-danger px-3 py-2 rounded-pill">Blocked</span>
        @else
            <span class="badge bg-success px-3 py-2 rounded-pill">Active</span>
        @endif
    </div>
</div>

<div class="row g-4">
    <div class="col-lg-4">
        <div class="card border-0 shadow-sm rounded-4 p-4 mb-4">
            <div class="text-center mb-4">
                 <div class="rounded-circle bg-primary bg-opacity-10 d-flex align-items-center justify-content-center mx-auto mb-3" style="width: 80px; height: 80px;">
                    <i class="fa-solid fa-user text-primary fa-2x"></i>
                 </div>
                 <h5 class="fw-800 mb-1">{{ $user->name }}</h5>
                 <p class="text-muted small mb-0">{{ $user->email }}</p>
                 <span class="badge bg-light text-muted extra-small mt-2 rounded-pill">Member since {{ $user->created_at->format('M Y') }}</span>
            </div>
            
            <hr>

            <div class="row g-3 mb-4">
                <div class="col-12">
                     <label class="extra-small text-muted text-uppercase fw-700">Mobile Number</label>
                     <p class="small fw-600 text-dark">{{ $user->mobile ?? 'Not Provided' }}</p>
                </div>
                <div class="col-12">
                     <label class="extra-small text-muted text-uppercase fw-700">Account Role</label>
                     <p class="small fw-600 text-dark">{{ $user->role ?? 'Standard User' }}</p>
                </div>
            </div>

            <div class="d-grid gap-2">
                <form action="{{ route('admin.users.toggleBlock', $user->id) }}" method="POST">
                    @csrf
                    <button type="submit" class="btn {{ $user->is_blocked ? 'btn-success' : 'btn-danger' }} w-100 rounded-pill fw-bold shadow-sm">
                        {{ $user->is_blocked ? 'Unblock Account' : 'Block This User' }}
                    </button>
                </form>
            </div>
        </div>
    </div>

    <div class="col-lg-8">
        <div class="card border-0 shadow-sm rounded-4 overflow-hidden">
            <div class="card-header bg-white py-3 px-4">
                <h6 class="fw-800 mb-0">Reports Submitted by User ({{ count($reports) }})</h6>
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table mb-0 align-middle">
                        <thead>
                            <tr class="bg-light">
                                <th class="ps-4 extra-small">Case Name</th>
                                <th class="extra-small">Status</th>
                                <th class="extra-small">Date</th>
                                <th class="text-end pe-4 extra-small">Management</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($reports as $rep)
                            <tr>
                                <td class="ps-4">
                                    <div class="d-flex align-items-center">
                                        <img src="{{ asset('storage/' . $rep->photo) }}" class="rounded-3 shadow-sm me-2" style="width: 40px; height: 40px; object-fit: cover;">
                                        <div class="fw-600 text-dark small">{{ $rep->name }}</div>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-{{ $rep->fir_status == 'Verified' ? 'success' : 'warning' }} bg-opacity-10 text-{{ $rep->fir_status == 'Verified' ? 'success' : 'dark' }} rounded-pill extra-small px-2">
                                        {{ $rep->fir_status }}
                                    </span>
                                </td>
                                <td>
                                    <div class="extra-small text-muted">{{ $rep->created_at->format('d M, Y') }}</div>
                                </td>
                                <td class="text-end pe-4">
                                    <a href="{{ route('admin.reports.show', $rep->id) }}" class="btn btn-light btn-sm rounded-pill p-2" style="width: 32px; height: 32px;">
                                        <i class="fa-solid fa-arrow-right-long text-primary"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="4" class="text-center py-5 text-muted small">No reports submitted by this user.</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .extra-small { font-size: 0.7rem; }
</style>
@endsection
