<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\MissingPerson;
use App\Models\Tip;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class DummyDataSeeder extends Seeder
{
    public function run(): void
    {
        // 1. Ensure Admin User
        $admin = User::updateOrCreate(
            ['email' => 'admin@find.com'],
            [
                'name' => 'Super Admin',
                'password' => Hash::make('admin123'),
                'is_admin' => true,
                'role' => 'Super Admin',
                'mobile' => '9888877777'
            ]
        );

        // 2. Ensure Test User
        $testUser = User::updateOrCreate(
            ['email' => 'test@example.com'],
            [
                'name' => 'John Doe',
                'password' => Hash::make('password'),
                'is_admin' => false,
                'role' => 'User',
                'mobile' => '9111122222'
            ]
        );

        // 3. Create some more random users
        $users = [];
        $names = ['Rahul Sharma', 'Anjali Gupta', 'Vikram Singh', 'Priya Patel', 'Aman Verma'];
        foreach ($names as $name) {
            $email = strtolower(str_replace(' ', '.', $name)) . '@example.com';
            $users[] = User::updateOrCreate(
                ['email' => $email],
                [
                    'name' => $name,
                    'password' => Hash::make('password'),
                    'is_admin' => false,
                    'role' => 'User',
                    'mobile' => '9' . rand(100000000, 999999999)
                ]
            );
        }

        // 4. Create Missing Person Reports
        $reports = [
            [
                'name' => 'Sameer Khan',
                'age' => 24,
                'gender' => 'Male',
                'last_seen_location' => 'Chandni Chowk, Delhi',
                'date_missing' => now()->subDays(10),
                'status' => 'Active',
                'is_verified' => true,
                'fir_status' => 'Verified'
            ],
            [
                'name' => 'Kavita Kumari',
                'age' => 12,
                'gender' => 'Female',
                'last_seen_location' => 'Railway Station, Patna',
                'date_missing' => now()->subDays(5),
                'status' => 'Active',
                'is_verified' => false,
                'fir_status' => 'Pending'
            ],
            [
                'name' => 'Arun Goel',
                'age' => 65,
                'gender' => 'Male',
                'last_seen_location' => 'Sector 15, Gurgaon',
                'date_missing' => now()->subDays(20),
                'status' => 'Resolved',
                'is_verified' => true,
                'fir_status' => 'Verified'
            ],
            [
                'name' => 'Baby Pinki',
                'age' => 4,
                'gender' => 'Female',
                'last_seen_location' => 'Public Park, Jaipur',
                'date_missing' => now()->subDays(2),
                'status' => 'Active',
                'is_verified' => false,
                'fir_status' => 'Pending'
            ],
            [
                'name' => 'Mohit Yadav',
                'age' => 19,
                'gender' => 'Male',
                'last_seen_location' => 'Mumbai Marine Drive',
                'date_missing' => now()->subDays(15),
                'status' => 'Active',
                'is_verified' => true,
                'fir_status' => 'Verified'
            ],
        ];

        foreach ($reports as $index => $repData) {
            $owner = ($index % 2 == 0) ? $testUser : $users[array_rand($users)];
            
            MissingPerson::updateOrCreate(
                ['name' => $repData['name']],
                array_merge($repData, [
                    'user_id' => $owner->id,
                    'relation' => 'Relative',
                    'reporter_contact' => $owner->mobile ?? '9999999999',
                    'reporter_city' => 'New Delhi',
                    'reporter_state' => 'Delhi',
                    'height' => '5.6',
                    'complexion' => 'Fair',
                    'language' => 'Hindi, English',
                    'medical_condition' => 'Healthy',
                    'clothes' => 'Blue Shirt, Jeans',
                    'identification_marks' => 'Mole on right cheek',
                    'photo' => 'reports/dummy_photo.jpg', 
                    'fir_copy' => 'fir/dummy_fir.pdf',  
                ])
            );
        }

        // 6. Add Tips
        $allCases = MissingPerson::all();
        foreach ($allCases as $case) {
            if ($case->tips()->count() == 0) {
                Tip::create([
                    'missing_person_id' => $case->id,
                    'message' => 'The person was seen near the main square area speaking to some locals.',
                    'contact_info' => '9123456780'
                ]);
            }
        }
    }
}
