<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MissingPerson extends Model
{
    use HasFactory, SoftDeletes;
    
    protected $table = 'missing_persons';

    protected $fillable = [
        'user_id',
        'relation',
        'reporter_contact',
        'reporter_city',
        'reporter_state',
        'name',
        'age',
        'gender',
        'height',
        'complexion',
        'language',
        'date_missing',
        'last_seen_location',
        'medical_condition',
        'photo',
        'fir_copy',
        'fir_status',
        'verification_remarks',
        'identification_marks',
        'clothes',
        'status',
        'is_verified'
    ];

    protected $casts = [
        'date_missing' => 'date',
        'is_verified' => 'boolean',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function tips()
    {
        return $this->hasMany(Tip::class);
    }
}
