<?php

namespace App\Http\Controllers;

use App\Models\MissingPerson;
use App\Models\Tip;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $cases = MissingPerson::where('user_id', Auth::id())
                              ->withCount('tips')
                              ->latest()
                              ->get();

        return view('dashboard.index', compact('cases'));
    }

    public function showTips($id)
    {
        $missingPerson = MissingPerson::where('user_id', Auth::id())
                                      ->with(['tips' => function($q) {
                                          $q->latest();
                                      }])
                                      ->findOrFail($id);

        return view('dashboard.tips', compact('missingPerson'));
    }

    public function messages()
    {
        // Get all tips across all cases owned by the authenticated user
        $tips = Tip::whereHas('missingPerson', function($query) {
                        $query->where('user_id', Auth::id());
                    })
                    ->with('missingPerson')
                    ->latest()
                    ->get();

        return view('dashboard.messages', compact('tips'));
    }

    public function profile()
    {
        $user = Auth::user();
        return view('dashboard.profile', compact('user'));
    }

    public function updateProfile(Request $request)
    {
        $user = Auth::user();
        
        $request->validate([
            'name' => 'required|string|max:255',
            'mobile' => 'nullable|string|max:15',
        ]);

        $user->update([
            'name' => $request->name,
            'mobile' => $request->mobile,
        ]);

        return back()->with('success', 'Profile updated successfully.');
    }
}
