<?php

namespace App\Http\Controllers;

use App\Models\MissingPerson;
use App\Models\User;
use App\Models\Tip;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AdminController extends Controller
{
    public function index()
    {

        $allCases = MissingPerson::with('user')->latest()->limit(5)->get();
        $totalUsers = User::count();
        $totalReports = MissingPerson::count();
        $activeCases = MissingPerson::where('status', 'Active')->count();
        $resolvedCases = MissingPerson::where('status', 'Resolved')->count();
        $pendingVerifications = MissingPerson::where('is_verified', false)->count();

        $recentTips = Tip::with('missingPerson')->latest()->limit(5)->get();

        return view('admin.dashboard', compact(
            'allCases', 
            'totalUsers', 
            'totalReports', 
            'activeCases', 
            'resolvedCases', 
            'pendingVerifications',
            'recentTips'
        ));
    }
}
