<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\MissingPerson;
use Illuminate\Http\Request;

class ReportController extends Controller
{
    public function index(Request $request)
    {
        $query = MissingPerson::with('user')->latest();

        if ($request->has('search')) {
            $query->where('name', 'like', '%' . $request->search . '%');
        }

        if ($request->has('status')) {
            $query->where('status', $request->status);
        }

        $reports = $query->paginate(15);
        return view('admin.reports.index', compact('reports'));
    }

    public function show($id)
    {
        $report = MissingPerson::with(['user', 'tips'])->findOrFail($id);
        return view('admin.reports.show', compact('report'));
    }

    public function verify(Request $request, $id)
    {
        $report = MissingPerson::findOrFail($id);
        $report->is_verified = true;
        $report->fir_status = 'Verified';
        $report->status = 'Active';
        $report->verification_remarks = $request->remarks;
        $report->save();

        return back()->with('success', 'Report verified successfully.');
    }

    public function reject(Request $request, $id)
    {
        $report = MissingPerson::findOrFail($id);
        $report->fir_status = 'Rejected';
        $report->verification_remarks = $request->remarks;
        $report->save();

        return back()->with('success', 'Report rejected.');
    }

    public function destroy($id)
    {
        $report = MissingPerson::findOrFail($id);
        $report->delete(); // Soft delete

        return back()->with('success', 'Report soft-deleted.');
    }
}
