<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Tip;
use Illuminate\Http\Request;

class MessageController extends Controller
{
    public function index()
    {
        $messages = Tip::with('missingPerson')->latest()->paginate(20);
        return view('admin.messages.index', compact('messages'));
    }

    public function destroy($id)
    {
        $tip = Tip::findOrFail($id);
        $tip->delete();

        return back()->with('success', 'Message deleted.');
    }
}
